package game;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.util.ArrayList;


public class RainbowElementalSprite {
	
	private CustomImageDataII rainbowSpawnImages[];
	private CustomImageDataII rainbowImage;
	private CustomImageDataII rainbowDespawnImages[];
	private CustomImageDataII cloudSpawnImages[];
	private CustomImageDataII cloudImage;
	private CustomImageDataII cloudDespawnImages[];
	private CustomImageDataII cloudFlashImage;
	
	private int xPositions[];
	private int yPositions[];
	
	private int currentIndex;
	private char direction;
	
	public static final int MAX_POSITIONS = 200;
	
	public static final long EYE_PAUSE = 1000L;
	public static final int MOVEMENT_RADIUS = 365;
	
	private int xPos;
	private int yPos;
	
	public static final int MIN_MOVEMENT = 10;
	public static final int MAX_MOVEMENT = 190;
	
	public static final int MAX_BOSS_HP = 100;
	public static final int HP_DOWN_BEFORE_INVULNERABLE = 15;
	
	private int hp;
	private int nextLowestHpInvulnerabilityThreshold;
	
	private long lastTimeDamaged = Long.MIN_VALUE;
	private long lastTimeMadeInvulnerable = Long.MIN_VALUE;
	

	public static final long FLASHING_DURATION = 500L;
	public static final long INVULNERABLE_DURATION = 2000L;
	public static final int LIGHTNING_WIDTH = 16;
	
	public static final long INVULERABLE_DURATION_TICKS = INVULNERABLE_DURATION * 1000000L / PonyPanel.TICK_LENGTH_NANO;
	
	private long invulnerableTicks = INVULERABLE_DURATION_TICKS +1;
	
	public static final int BOSS_CLOUD_WIDTH = 112;
	public static final int BOSS_CLOUD_HEIGHT = 103;
	
	private int frame = 0;
	private int MAX_FRAMES = 10;
	
	public static final long LIGHTNING_OVERALL_DURATION = 2500L;
	public static final long LIGHTNING_DISPLAY_THRESHOLD = 800L;
	public static final long LIGHTNING_CHARGEUP = 1000L;
	private long startedLightning = Long.MIN_VALUE;
	
	
	public static final long LIGHTNING_CHARGEUP_TICKS = LIGHTNING_CHARGEUP * 1000000L / PonyPanel.TICK_LENGTH_NANO;
	public static final long LIGHTNING_DISPLAY_THRESHOLD_TICKS = LIGHTNING_DISPLAY_THRESHOLD * 1000000L / PonyPanel.TICK_LENGTH_NANO;
	public static final long LIGHTNING_OVERALL_DURATION_TICKS = LIGHTNING_OVERALL_DURATION * 1000000L / PonyPanel.TICK_LENGTH_NANO;
	
	private long lightningTicks = LIGHTNING_OVERALL_DURATION_TICKS + 1;
	
	
	public static final int PIXELS_BETWEEN_LIGHTNING_POINTS = 30;
	
	private boolean isDying = false;
	private boolean isAlive = false;
	
	private int frameOfDeath;
	
	public static final int LINE_LIGHTNING_POINTS = 10;
	
	private int flagSpawnX;
	private int flagSpawnY;
	
	private boolean movingPlayerToSafeSpot = false;
	
	private static final int MAX_SAFE_SPOT_STEP = 5;
	
	private boolean isVisible = false;
	private int spawnFrame = 0;
	
	private static final int SPAWN_X_TOLERANCE = 40;
	
	private int kind;
	
	private ArrayList<EnemySprite> enemies = null;
	
	public static final int NO_SPAWNING = 0;
	public static final int SPAWN_TWO = 1;
	public static final int SPAWN_SIX = 2;
	
	private int playerTractorBeamRatio;
	
	private static final int NO_SPAWNING_HURT_RADIUS = 345;
	private static final int SPAWNING_TWO_HURT_RADIUS = 345;
	private static final int SPAWNING_SIX_HURT_RADIUS = 320;
	private static final int ITEM_MAX_STEP = 10;
	
	
	public RainbowElementalSprite(int focusX, int focusY, int safeSpotX, int safeSpotY, int spawnEnemies, PonyPanel ponyPanel) {
		
		xPos = focusX;
		yPos = focusY;
		
		flagSpawnX = safeSpotX;
		flagSpawnY = safeSpotY;
		
		kind = spawnEnemies;
		enemies = new ArrayList<EnemySprite>();
		
		lightningTicks = LIGHTNING_OVERALL_DURATION_TICKS + 1;
		
		String rainbowImageStr;
		
		if(kind == SPAWN_TWO) {
			rainbowImageStr = "/images/boss/med_rainbow.GIF";
			playerTractorBeamRatio = SPAWNING_TWO_HURT_RADIUS;
		} else if(kind == SPAWN_SIX) {
			rainbowImageStr = "/images/boss/rainbow2.GIF";
			playerTractorBeamRatio = SPAWNING_SIX_HURT_RADIUS;
		} else {
			rainbowImageStr = "/images/boss/small_rainbow.GIF";
			playerTractorBeamRatio = NO_SPAWNING_HURT_RADIUS;
		}
		
//		ii = new ImageIcon(RainbowElementalSprite.class.getResource(rainbowImageStr));
//		rainbowImage = new CustomImageDataII(ii.getImage(), 800, 400, Color.black, ponyPanel);
		rainbowImage = new CustomImageDataII(rainbowImageStr, Color.black, ponyPanel);
		
		Image tempImage = null;
		
		rainbowSpawnImages = new CustomImageDataII[9];
		
//		for(int i = 0; i < 9; i++) {
//			tempImage = CustomImageDataII.makeImageMoreTransparentOfTen(ii.getImage(), i + 1);
//			rainbowSpawnImages[i] = new CustomImageDataII(tempImage, 800, 400, Color.black, ponyPanel);
//		}
		
		for(int i = 0; i < 9; i++) {
			rainbowSpawnImages[i] = rainbowImage.createCloneThatIsMoreTransparent(i, 10, false);
		}
		
		String rainbowDespawnImagesStr;
		
		if(kind == SPAWN_TWO) {
			rainbowDespawnImagesStr = "/images/boss/med_rainbow despawn ";
		} else if(kind == SPAWN_SIX) {
			rainbowDespawnImagesStr = "/images/boss/rainbow_despawn_";
		} else {
			rainbowDespawnImagesStr = "/images/boss/small_rainbow_desp ";
		}
		
		rainbowDespawnImages = new CustomImageDataII[8];
		for(int i = 0; i < 8; i++) {
//			ii = new ImageIcon(RainbowElementalSprite.class.getResource(rainbowDespawnImagesStr + (i+1) + ".GIF"));
//			rainbowDespawnImages[i]  = new CustomImageDataII(ii.getImage(), 800, 400, Color.black, ponyPanel);
			rainbowDespawnImages[i]  = new CustomImageDataII(rainbowDespawnImagesStr + (i+1) + ".GIF", Color.black, ponyPanel);
		}
		
		
//		ii = new ImageIcon(RainbowElementalSprite.class.getResource("images/boss/cloud spawn A 3.GIF"));
		
//		cloudImage = new CustomImageDataII(ii.getImage(), 112, 103, Color.white, ponyPanel);
		cloudImage = new CustomImageDataII("/images/boss/cloud spawn A 3.GIF", Color.white, ponyPanel);
		
//		ii = new ImageIcon(RainbowElementalSprite.class.getResource("images/boss/cloud flash.GIF"));
//		cloudFlashImage = new CustomImageDataII(ii.getImage(), 112, 103, Color.white, ponyPanel);
		cloudFlashImage = new CustomImageDataII("/images/boss/cloud flash.GIF", Color.white, ponyPanel);
		
		cloudSpawnImages = new CustomImageDataII[9];
		
//		ii = new ImageIcon(RainbowElementalSprite.class.getResource("images/boss/cloud spawn 1.GIF"));
//		cloudSpawnImages[0] = new CustomImageDataII(ii.getImage(), 112, 103, Color.white, ponyPanel);
		cloudSpawnImages[0] = new CustomImageDataII("/images/boss/cloud spawn 1.GIF", Color.white, ponyPanel);
		
//		ii = new ImageIcon(RainbowElementalSprite.class.getResource("images/boss/cloud spawn 2.GIF"));
//		cloudSpawnImages[1] = new CustomImageDataII(ii.getImage(), 112, 103, Color.white, ponyPanel);
		cloudSpawnImages[1] = new CustomImageDataII("/images/boss/cloud spawn 2.GIF", Color.white, ponyPanel);
		
//		ii = new ImageIcon(RainbowElementalSprite.class.getResource("images/boss/cloud spawn 3.GIF"));
//		cloudSpawnImages[2] = new CustomImageDataII(ii.getImage(), 112, 103, Color.white, ponyPanel);
		cloudSpawnImages[2] = new CustomImageDataII("/images/boss/cloud spawn 3.GIF", Color.white, ponyPanel);
		
//		ii = new ImageIcon(RainbowElementalSprite.class.getResource("images/boss/cloud spawn 4.GIF"));
//		cloudSpawnImages[3] = new CustomImageDataII(ii.getImage(), 112, 103, Color.white, ponyPanel);
		cloudSpawnImages[3] = new CustomImageDataII("/images/boss/cloud spawn 4.GIF", Color.white, ponyPanel);
		
//		ii = new ImageIcon(RainbowElementalSprite.class.getResource("images/boss/cloud spawn 5.GIF"));
//		cloudSpawnImages[4] = new CustomImageDataII(ii.getImage(), 112, 103, Color.white, ponyPanel);
		cloudSpawnImages[4] = new CustomImageDataII("/images/boss/cloud spawn 5.GIF", Color.white, ponyPanel);
		
//		ii = new ImageIcon(RainbowElementalSprite.class.getResource("images/boss/cloud spawn 6.GIF"));
//		cloudSpawnImages[5] = new CustomImageDataII(ii.getImage(), 112, 103, Color.white, ponyPanel);
		cloudSpawnImages[5] = new CustomImageDataII("/images/boss/cloud spawn 6.GIF", Color.white, ponyPanel);
		
//		ii = new ImageIcon(RainbowElementalSprite.class.getResource("images/boss/cloud spawn 7.GIF"));
//		cloudSpawnImages[6] = new CustomImageDataII(ii.getImage(), 112, 103, Color.white, ponyPanel);
		cloudSpawnImages[6] = new CustomImageDataII("/images/boss/cloud spawn 7.GIF", Color.white, ponyPanel);
		
//		ii = new ImageIcon(RainbowElementalSprite.class.getResource("images/boss/cloud spawn A 1.GIF"));
//		cloudSpawnImages[7] = new CustomImageDataII(ii.getImage(), 112, 103, Color.white, ponyPanel);
		cloudSpawnImages[7] = new CustomImageDataII("/images/boss/cloud spawn A 1.GIF", Color.white, ponyPanel);
		
//		ii = new ImageIcon(RainbowElementalSprite.class.getResource("images/boss/cloud spawn A 2.GIF"));
//		cloudSpawnImages[8] = new CustomImageDataII(ii.getImage(), 112, 103, Color.white, ponyPanel);
		cloudSpawnImages[8] = new CustomImageDataII("/images/boss/cloud spawn A 2.GIF", Color.white, ponyPanel);
		
		
		
		cloudDespawnImages = new CustomImageDataII[8];
		
		for(int i = 7; i >= 0; i--) {
//			tempImage = CustomImageDataII.makeImageMoreTransparentOfEight(cloudImage.getImage(), i);
//			cloudDespawnImages[7-i] = new CustomImageDataII(tempImage, 112,103,Color.WHITE, ponyPanel);
			cloudDespawnImages[7-i] = cloudImage.createCloneThatIsMoreTransparent(i, 8, i == 7);
		}
		
		
		currentIndex = MAX_POSITIONS * 3 / 4;
		direction = 'r';
		
		xPositions = new int[MAX_POSITIONS];
		yPositions = new int[MAX_POSITIONS];
		
		double inputter;
		
		for(int i = 0; i < MAX_POSITIONS; i++) {
			
			inputter = i * (Math.PI / MAX_POSITIONS) ; //- Math.PI / 2
			
			xPositions[i] = (int) (-Math.cos(inputter) * MOVEMENT_RADIUS) + focusX;
			yPositions[i] = (int) (-Math.sin(inputter) * MOVEMENT_RADIUS) + focusY;
			
//			System.out.println("position " + i + ":  (" + xPositions[i] + ", " + yPositions[i] + ")");
			
		}
		
		hp = MAX_BOSS_HP;
		nextLowestHpInvulnerabilityThreshold = MAX_BOSS_HP - HP_DOWN_BEFORE_INVULNERABLE;
		
		
		isDying = false;
		isAlive = true;
		frameOfDeath = Integer.MIN_VALUE;
		
		isVisible = false;
		spawnFrame = 0;
		
	}
	
	
	
	
	public boolean isDying() {
		return isDying;
	}




	public boolean isAlive() {
		return isAlive;
	}



	
	
	private void drawLightningLine(Graphics g, int startX, int startY, int destinationX, int destinationY, int beamWidth, Color col) {
		
		IntPoint points[] = new IntPoint[LINE_LIGHTNING_POINTS];
		
		int xOffSet, yOffSet;
		
		int xFactor = (destinationX - startX) / LINE_LIGHTNING_POINTS;
		int yFactor = (destinationY - startY) / LINE_LIGHTNING_POINTS;
		
		for(int i = 0; i < LINE_LIGHTNING_POINTS - 1; i++) {
			
			if(i == 0) {
				points[i] =  new IntPoint(startX, startY);
			} else {
				xOffSet = (int) (Math.random() * beamWidth - beamWidth / 2);
				yOffSet = (int) (Math.random() * beamWidth - beamWidth / 2);
				
				points[i] = new IntPoint(xOffSet + startX + i * xFactor, yOffSet + startY + i * yFactor);
				
			}
			
		}
		
		points[LINE_LIGHTNING_POINTS - 1] = new IntPoint(destinationX, destinationY);
		
		Color origColor = g.getColor();
		g.setColor(col);
		
		for (int i = 0; i < points.length - 1; i++) {
			g.drawLine(points[i].x, points[i].y, points[i+1].x, points[i + 1].y); 
		}
		
		g.setColor(origColor);
		
	}

	public void update(PonyPanel panel, PlayerSprite player, EnemyImageManager enemyImageManager, ArrayList<ItemSprite> items) {
		
		
		if(!isVisible) {
			if(Math.abs(player.getxPos() - xPos) <= SPAWN_X_TOLERANCE && player.getyPos() <= yPos && player.getyPos() >= (yPos - MOVEMENT_RADIUS)) {
				isVisible = true;
			}
			return;
		} else if(spawnFrame < 9) {
			spawnFrame++;
			return;
		}
		
		if(isInvulnerable())
			invulnerableTicks++;
		

		if(isDying) {
			frameOfDeath++;
			if(frameOfDeath >= cloudDespawnImages.length || frameOfDeath >= rainbowDespawnImages.length) {
				isAlive = false;
				return;
			}
		} else {
			updateFiring(panel);
		}
		
		ItemSprite item = null;
		boolean alreadyMovedHorizontal, alreadyMovedVertical;
		for(int i = 0; i < items.size(); i++) {
			
			item = items.get(i);
			
//			alreadyMovedHorizontal = false;
//			if(item.getxPos() < xPos - playerTractorBeamRatio ) {
//				//need to move the item in from the left
//				item.setxPos(item.getxPos() + ITEM_MAX_STEP);
//				alreadyMovedHorizontal = true;
//			} else if(item.getxPos() > xPos + playerTractorBeamRatio) {
//				item.setxPos(item.getxPos() - ITEM_MAX_STEP);
//				alreadyMovedHorizontal = true;
//			} 
//			
//			
//			alreadyMovedVertical = false;
//			if(item.getyPos() < yPos - playerTractorBeamRatio) {
//				item.setyPos(item.getyPos() + ITEM_MAX_STEP);
//				alreadyMovedVertical = true;
//			} else if(item.getyPos() > yPos) {
//				item.setyPos(item.getyPos() - ITEM_MAX_STEP);
//				alreadyMovedVertical = true;
//			}
//			
//			if(!alreadyMovedHorizontal || !alreadyMovedVertical) {
				
			if(item.getyPos() < yPos) {
				int distance = (int) Math.sqrt((xPos - item.getxPos()) * (xPos - item.getxPos()) + (yPos - item.getyPos()) * (yPos - item.getyPos()));
				if(distance > playerTractorBeamRatio * 3 / 4) {
			
					//need to move this pooch!
						
					if(xPos == item.getxPos()) {
						//just figure out whether to move them item up or down!  And it has to be "down", too...
						
						item.setyPos(item.getyPos() + ITEM_MAX_STEP);
						
					} else {
						
						double slope = Math.abs(item.getxPos() - xPos) * 1.0 / Math.abs(item.getyPos() - yPos);
						
						int xStep, yStep;
						
						if(slope < 1.0) {
							//more run, less rise
							xStep = ITEM_MAX_STEP;
							yStep = (int) Math.ceil(ITEM_MAX_STEP / slope);
						} else {
							yStep = ITEM_MAX_STEP;
							xStep = (int) Math.ceil(ITEM_MAX_STEP * slope);
						}
						
						if(xPos > item.getxPos()) {
							//move it left
							item.setxPos(item.getxPos() + xStep);
						} else {
							item.setxPos(item.getxPos() - xStep);
						}
						
						item.setyPos(item.getyPos() + yStep);
						
					}
					
					
				}
			}
			
			
		}
		
		
		frame++;
		if(frame >= MAX_FRAMES) {
			frame = 0;
		}
		
		if(direction == 'r') {
			
			currentIndex++;
			if(currentIndex >= MAX_MOVEMENT) {
				currentIndex = MAX_MOVEMENT - 2;
				direction = 'l';
			}
			
		} else {

			currentIndex--;
			if(currentIndex < MIN_MOVEMENT) {
				currentIndex = MIN_MOVEMENT + 1;
				direction = 'r';
			}
			
		}
		
		if(Math.sqrt(((xPos - player.getxPos()) * (xPos - player.getxPos()) + (yPos - player.getyPos()) * (yPos - player.getyPos()))) > playerTractorBeamRatio) {
			movingPlayerToSafeSpot = true;
			player.setCutsceneMode();
			player.setVerticalMode(PlayerSprite.FALLING);
		}
		
		if(movingPlayerToSafeSpot) {
			
			if(Math.abs(player.getxPos() - flagSpawnX) < MAX_SAFE_SPOT_STEP)
				player.setxPos(flagSpawnX);
			else {
				if(player.getxPos() > flagSpawnX) {
					player.setxPos(player.getxPos() - MAX_SAFE_SPOT_STEP);
				} else {
					player.setxPos(player.getxPos() + MAX_SAFE_SPOT_STEP);
				}
			}
			
			
			if(Math.abs(player.getyPos() - flagSpawnY) < MAX_SAFE_SPOT_STEP)
				player.setyPos(flagSpawnY);
			else {
				if(player.getyPos() > flagSpawnY) {
					player.setyPos(player.getyPos() - MAX_SAFE_SPOT_STEP);
				} else {
					player.setyPos(player.getyPos() + MAX_SAFE_SPOT_STEP);
				}
			}
			
			
			if(player.getxPos() == flagSpawnX && player.getyPos() == flagSpawnY) {
				movingPlayerToSafeSpot = false;
				player.endCutsceneMode();
				player.takeDamage();
			}
			
		}
		
		if(kind == SPAWN_SIX) {
			
			for(int i = 0; i < enemies.size(); i++) {
				if(enemies.get(i).getHP() <= 0) {
					enemies.remove(i);
					i--;
				}
			}
			
			
			if(enemies.size() < 6) {
				
				
				if(currentIndex == MAX_POSITIONS * 3 / 4) {
					if(!spawnedEnemyExistsAtCurrentPosition()) {
						EnemySprite newEnemy = new EnemySprite();
						newEnemy.popupate(xPositions[currentIndex], yPositions[currentIndex], EnemySprite.UP_DOWN_TURRET, yPositions[currentIndex], yPos, 'd', enemyImageManager, panel);
						enemies.add(newEnemy);
						panel.addEnemy(newEnemy);
					}
				} else if(currentIndex == MAX_POSITIONS / 4) {
					if(!spawnedEnemyExistsAtCurrentPosition()) {
						EnemySprite newEnemy = new EnemySprite();
						newEnemy.popupate(xPositions[currentIndex], yPositions[currentIndex], EnemySprite.UP_DOWN_TURRET, yPositions[currentIndex],  yPos, 'd', enemyImageManager, panel);
						enemies.add(newEnemy);
						panel.addEnemy(newEnemy);
					}
				} else if(currentIndex == MAX_POSITIONS / 3) {
					if(!spawnedEnemyExistsAtCurrentPosition()) {
						EnemySprite newEnemy = new EnemySprite();
						newEnemy.popupate(xPositions[currentIndex], yPositions[currentIndex], EnemySprite.UP_DOWN_TURRET, yPositions[currentIndex],  yPos, 'd', enemyImageManager, panel);
						enemies.add(newEnemy);
						panel.addEnemy(newEnemy);
					}
				} else if(currentIndex == MAX_POSITIONS * 2 / 3) {
					if(!spawnedEnemyExistsAtCurrentPosition()) {
						EnemySprite newEnemy = new EnemySprite();
						newEnemy.popupate(xPositions[currentIndex], yPositions[currentIndex], EnemySprite.UP_DOWN_TURRET, yPositions[currentIndex],  yPos, 'd', enemyImageManager, panel);
						enemies.add(newEnemy);
						panel.addEnemy(newEnemy);
					}
				} else if(currentIndex == MAX_POSITIONS / 6) {
					if(!spawnedEnemyExistsAtCurrentPosition()) {
						EnemySprite newEnemy = new EnemySprite();
						newEnemy.popupate(xPositions[currentIndex], yPositions[currentIndex], EnemySprite.UP_DOWN_TURRET, yPositions[currentIndex],  yPos, 'd', enemyImageManager, panel);
						enemies.add(newEnemy);
						panel.addEnemy(newEnemy);
					}
				} else if(currentIndex == MAX_POSITIONS * 5 / 6) {
					if(!spawnedEnemyExistsAtCurrentPosition()) {
						EnemySprite newEnemy = new EnemySprite();
						newEnemy.popupate(xPositions[currentIndex], yPositions[currentIndex], EnemySprite.UP_DOWN_TURRET, yPositions[currentIndex],  yPos, 'd', enemyImageManager, panel);
						enemies.add(newEnemy);
						panel.addEnemy(newEnemy);
					}
				}
			}
			
		} else if(kind == SPAWN_TWO) {
			
			
			for(int i = 0; i < enemies.size(); i++) {
				if(enemies.get(i).getHP() <= 0) {
					enemies.remove(i);
					i--;
				}
			}
			
			
			if(enemies.size() < 2) {
				
				
				if(currentIndex == MAX_POSITIONS * 3 / 4) {
					if(!spawnedEnemyExistsAtCurrentPosition()) {
						EnemySprite newEnemy = new EnemySprite();
						newEnemy.popupate(xPositions[currentIndex], yPositions[currentIndex], EnemySprite.UP_DOWN_TURRET, yPositions[currentIndex], yPos, 'd', enemyImageManager, panel);
						enemies.add(newEnemy);
						panel.addEnemy(newEnemy);
					}
				} else if(currentIndex == MAX_POSITIONS / 4) {
					if(!spawnedEnemyExistsAtCurrentPosition()) {
						EnemySprite newEnemy = new EnemySprite();
						newEnemy.popupate(xPositions[currentIndex], yPositions[currentIndex], EnemySprite.UP_DOWN_TURRET, yPositions[currentIndex],  yPos, 'd', enemyImageManager, panel);
						enemies.add(newEnemy);
						panel.addEnemy(newEnemy);
					}
				}
			}
			
		}
		
		
	}
	
	private boolean spawnedEnemyExistsAtCurrentPosition() {

		for(int i = 0; i < enemies.size(); i++) {
			if(enemies.get(i).getxPos() == xPositions[currentIndex])
				return true;
			
		}
		return false;
	}
	
	public void draw(Graphics g, PlayerSprite player, int panelWidth, int panelHeight) {
		
		if(!isVisible)
			return;
		
		if(spawnFrame < 9) {
			rainbowSpawnImages[this.spawnFrame].drawObject(g, panelWidth/2 + (xPos - player.getxPos()) , panelHeight/2 + (yPos - 200 - player.getyPos()));
			cloudSpawnImages[this.spawnFrame].drawObject(g, panelWidth/2 + (xPositions[currentIndex] - player.getxPos()), panelHeight/2 + (yPositions[currentIndex] - player.getyPos()));
			return;
		}
		

		if(isDying) {
			
			if(this.frameOfDeath >= rainbowDespawnImages.length || this.frameOfDeath >= cloudDespawnImages.length)
				return;
			
			rainbowDespawnImages[this.frameOfDeath].drawObject(g, panelWidth/2 + (xPos - player.getxPos()) , panelHeight/2 + (yPos - 200 - player.getyPos()));
			cloudDespawnImages[this.frameOfDeath].drawObject(g, panelWidth/2 + (xPositions[currentIndex] - player.getxPos()), panelHeight/2 + (yPositions[currentIndex] - player.getyPos()));
			return;
		}
		

		Color lightningColor = PlayingWithCosine.scalarToColor(Math.random());
		
		if(movingPlayerToSafeSpot) {
			drawLightningLine(g, panelWidth/2, panelHeight/2, panelWidth/2 + (xPositions[MAX_POSITIONS * 3/4] - player.getxPos()), panelHeight/2 + (yPositions[MAX_POSITIONS * 3/4] - player.getyPos()), 30, lightningColor);
			drawLightningLine(g, panelWidth/2, panelHeight/2, panelWidth/2 + (xPositions[MAX_POSITIONS * 1/4] - player.getxPos()), panelHeight/2 + (yPositions[MAX_POSITIONS * 1/4] - player.getyPos()), 30, lightningColor);
			drawLightningChargeEight(30, panelWidth/2, panelHeight/2, lightningColor, g, 20);
			drawLightningLine(g, panelWidth/2, panelHeight/2, panelWidth/2 + (xPositions[MAX_POSITIONS * 3/4] - player.getxPos()), panelHeight/2 + (yPositions[MAX_POSITIONS * 3/4] - player.getyPos()), 30, lightningColor);
			drawLightningLine(g, panelWidth/2, panelHeight/2, panelWidth/2 + (xPositions[MAX_POSITIONS * 1/4] - player.getxPos()), panelHeight/2 + (yPositions[MAX_POSITIONS * 1/4] - player.getyPos()), 30, lightningColor);
			drawLightningChargeEight(30, panelWidth/2, panelHeight/2, lightningColor, g, 20);
		}
		
		rainbowImage.drawObject(g, panelWidth/2 + (xPos - player.getxPos()) , panelHeight/2 + (yPos - 200 - player.getyPos()));
		
		
		
		if(isLightningingForDraw()) {

			int xDraw = panelWidth/2 + (xPositions[currentIndex] - player.getxPos());
			int yDraw = panelHeight/2 + (yPositions[currentIndex] - player.getyPos());
			int yDrawBase = panelHeight/2 + (yPos - player.getyPos());
			
			drawLightning(xDraw, yDraw, yDrawBase, g, 20, lightningColor);
			drawLightning(xDraw, yDraw, yDrawBase, g, 30, lightningColor);
			
			
			//drawLightningLine(g, xDraw, yDraw, panelWidth/2 + (xPos) - player.getxPos(), panelHeight / 2 + yPos - player.getyPos(), 30, lightningColor);
			
		}
		
		if(System.currentTimeMillis() < lastTimeDamaged + FLASHING_DURATION && frame % 5 <= 1	) {
			cloudFlashImage.drawObject(g, panelWidth/2 + (xPositions[currentIndex] - player.getxPos()), panelHeight/2 + (yPositions[currentIndex] - player.getyPos()));
		} else {
			cloudImage.drawObject(g, panelWidth/2 + (xPositions[currentIndex] - player.getxPos()), panelHeight/2 + (yPositions[currentIndex] - player.getyPos()));
		}
		
		if(isCharging()) {
			drawLightningChargeTwelve(65, panelWidth/2 + (xPositions[currentIndex] - player.getxPos()), panelHeight/2 + (yPositions[currentIndex] - player.getyPos()), lightningColor, g, 30 );
		}
		
		if(isInvulnerable())
			drawLightningChargeSixteen(80, panelWidth/2 + (xPositions[currentIndex] - player.getxPos()), panelHeight/2 + (yPositions[currentIndex] - player.getyPos()), Color.white, g, 16 );
		
	}
	
	public boolean isCharging() {
//		return System.currentTimeMillis() < startedLightning + LIGHTNING_CHARGEUP;
		return lightningTicks <= LIGHTNING_CHARGEUP_TICKS;
	}
	
	public boolean isInvulnerable() {
//		return System.currentTimeMillis() < lastTimeMadeInvulnerable + INVULNERABLE_DURATION;
		return invulnerableTicks <= INVULERABLE_DURATION_TICKS;
	}

	public class IntPoint {
		public int x;
		public int y;
		
		public IntPoint(int theX, int theY) {
			x = theX;
			y = theY;
		}
	}
	
	public void drawLightningChargeTwelve(int radius, int xDraw, int yDraw, Color color, Graphics g, int beamWidth) {
		
//		IntPoint pointArray[] = new IntPoint[8];
//		
//		pointArray[0] = new IntPoint(xDraw, yDraw - radius);
//		pointArray[1] = new IntPoint(xDraw + radius * 3/4, yDraw - radius*3/4);
//		pointArray[2] = new IntPoint(xDraw + radius, yDraw);
//		pointArray[3] = new IntPoint(xDraw + radius * 3/4, yDraw + radius*3/4);
//		pointArray[4] = new IntPoint(xDraw, yDraw + radius);
//		pointArray[5] = new IntPoint(xDraw - radius * 3/4, yDraw + radius*3/4);
//		pointArray[6] = new IntPoint(xDraw - radius, yDraw);
//		pointArray[7] = new IntPoint(xDraw - radius * 3/4, yDraw - radius*3/4);
		
		IntPoint pointArray[] = new IntPoint[12];
		
		pointArray[0] = new IntPoint(xDraw, yDraw - radius);
		pointArray[1] = new IntPoint(xDraw + radius * 2/5, yDraw - radius*4/5);
		pointArray[2] = new IntPoint(xDraw + radius * 4/5, yDraw - radius*2/5);
		pointArray[3] = new IntPoint(xDraw + radius, yDraw);
		pointArray[4] = new IntPoint(xDraw + radius * 4/5, yDraw + radius*2/5);
		pointArray[5] = new IntPoint(xDraw + radius * 2/5, yDraw + radius*4/5);
		pointArray[6] = new IntPoint(xDraw, yDraw + radius);
		pointArray[7] = new IntPoint(xDraw - radius * 2/5, yDraw + radius*4/5);
		pointArray[8] = new IntPoint(xDraw - radius * 4/5, yDraw + radius*2/5);
		pointArray[9] = new IntPoint(xDraw - radius, yDraw);
		pointArray[10] = new IntPoint(xDraw - radius * 4/5, yDraw - radius*2/5);
		pointArray[11] = new IntPoint(xDraw - radius * 2/5, yDraw - radius*4/5);
		

		int xOffSet, yOffSet;
		
		for(int i = 0; i < pointArray.length; i++) {
			xOffSet = (int) (Math.random() * beamWidth - beamWidth / 2);
			yOffSet = (int) (Math.random() * beamWidth - beamWidth / 2);
			pointArray[i].x += xOffSet;
			pointArray[i].y += yOffSet;
		}
		
		
		Color origColor = g.getColor();
		g.setColor(color);
		
		for(int i = 0; i < pointArray.length - 1; i++) {
			
			g.drawLine(pointArray[i].x, pointArray[i].y, pointArray[i + 1].x, pointArray[i+1].y);
			
		}
		
		g.drawLine(pointArray[0].x, pointArray[0].y, pointArray[pointArray.length - 1].x, pointArray[pointArray.length - 1].y);
		
		g.setColor(origColor);
		
		
	}
	

	public void drawLightningChargeSixteen(int radius, int xDraw, int yDraw, Color color, Graphics g, int beamWidth) {
		
//		IntPoint pointArray[] = new IntPoint[8];
//		
//		pointArray[0] = new IntPoint(xDraw, yDraw - radius);
//		pointArray[1] = new IntPoint(xDraw + radius * 3/4, yDraw - radius*3/4);
//		pointArray[2] = new IntPoint(xDraw + radius, yDraw);
//		pointArray[3] = new IntPoint(xDraw + radius * 3/4, yDraw + radius*3/4);
//		pointArray[4] = new IntPoint(xDraw, yDraw + radius);
//		pointArray[5] = new IntPoint(xDraw - radius * 3/4, yDraw + radius*3/4);
//		pointArray[6] = new IntPoint(xDraw - radius, yDraw);
//		pointArray[7] = new IntPoint(xDraw - radius * 3/4, yDraw - radius*3/4);
		
		IntPoint pointArray[] = new IntPoint[16];
		
		pointArray[0] = new IntPoint(xDraw, yDraw - radius);
		pointArray[1] = new IntPoint(xDraw + radius * 2/5, yDraw - radius*4/5);
		pointArray[2] = new IntPoint(xDraw + radius * 3/4, yDraw - radius*3/4);
		pointArray[3] = new IntPoint(xDraw + radius * 4/5, yDraw - radius*2/5);
		pointArray[4] = new IntPoint(xDraw + radius, yDraw);
		pointArray[5] = new IntPoint(xDraw + radius * 4/5, yDraw + radius*2/5);
		pointArray[6] = new IntPoint(xDraw + radius * 3/4, yDraw + radius*3/4);
		pointArray[7] = new IntPoint(xDraw + radius * 2/5, yDraw + radius*4/5);
		pointArray[8] = new IntPoint(xDraw, yDraw + radius);
		pointArray[9] = new IntPoint(xDraw - radius * 2/5, yDraw + radius*4/5);
		pointArray[10] = new IntPoint(xDraw - radius * 3/4, yDraw + radius*3/4);
		pointArray[11] = new IntPoint(xDraw - radius * 4/5, yDraw + radius*2/5);
		pointArray[12] = new IntPoint(xDraw - radius, yDraw);
		pointArray[13] = new IntPoint(xDraw - radius * 4/5, yDraw - radius*2/5);
		pointArray[14] = new IntPoint(xDraw - radius * 3/4, yDraw - radius*3/4);
		pointArray[15] = new IntPoint(xDraw - radius * 2/5, yDraw - radius*4/5);
		

		int xOffSet, yOffSet;
		
		for(int i = 0; i < pointArray.length; i++) {
			xOffSet = (int) (Math.random() * beamWidth - beamWidth / 2);
			yOffSet = (int) (Math.random() * beamWidth - beamWidth / 2);
			pointArray[i].x += xOffSet;
			pointArray[i].y += yOffSet;
		}
		
		
		Color origColor = g.getColor();
		g.setColor(color);
		
		for(int i = 0; i < pointArray.length - 1; i++) {
			
			g.drawLine(pointArray[i].x, pointArray[i].y, pointArray[i + 1].x, pointArray[i+1].y);
			
		}
		
		g.drawLine(pointArray[0].x, pointArray[0].y, pointArray[pointArray.length - 1].x, pointArray[pointArray.length - 1].y);
		
		g.setColor(origColor);
		
		
	}
	
	public void drawLightningChargeEight(int radius, int xDraw, int yDraw, Color color, Graphics g, int beamWidth) {
		
		IntPoint pointArray[] = new IntPoint[8];
		
		pointArray[0] = new IntPoint(xDraw, yDraw - radius);
		pointArray[1] = new IntPoint(xDraw + radius * 3/4, yDraw - radius*3/4);
		pointArray[2] = new IntPoint(xDraw + radius, yDraw);
		pointArray[3] = new IntPoint(xDraw + radius * 3/4, yDraw + radius*3/4);
		pointArray[4] = new IntPoint(xDraw, yDraw + radius);
		pointArray[5] = new IntPoint(xDraw - radius * 3/4, yDraw + radius*3/4);
		pointArray[6] = new IntPoint(xDraw - radius, yDraw);
		pointArray[7] = new IntPoint(xDraw - radius * 3/4, yDraw - radius*3/4);
		

		int xOffSet, yOffSet;
		
		for(int i = 0; i < pointArray.length; i++) {
			xOffSet = (int) (Math.random() * beamWidth - beamWidth / 2);
			yOffSet = (int) (Math.random() * beamWidth - beamWidth / 2);
			pointArray[i].x += xOffSet;
			pointArray[i].y += yOffSet;
		}
		
		
		Color origColor = g.getColor();
		g.setColor(color);
		
		for(int i = 0; i < pointArray.length - 1; i++) {
			
			g.drawLine(pointArray[i].x, pointArray[i].y, pointArray[i + 1].x, pointArray[i+1].y);
			
		}
		
		g.drawLine(pointArray[0].x, pointArray[0].y, pointArray[pointArray.length - 1].x, pointArray[pointArray.length - 1].y);
		
		g.setColor(origColor);
		
		
	}
	
	
	public void takeDamage(int damage) {
		
		if(isInvulnerable() || !isVisible())
			return;
		
		hp -= damage;
		lastTimeDamaged = System.currentTimeMillis();
		
		if(hp <= nextLowestHpInvulnerabilityThreshold) {
			hp = nextLowestHpInvulnerabilityThreshold;
			nextLowestHpInvulnerabilityThreshold -= HP_DOWN_BEFORE_INVULNERABLE;
			
//			lastTimeMadeInvulnerable = System.currentTimeMillis();
			invulnerableTicks = 0;
		}
		
		
		if( hp <= 0) {
			isDying = true;
			frameOfDeath = 0;
		}
	}
	
	public IntRect getCollisionRect() {
		
		int xPosCenter = xPositions[currentIndex];
		int yPosCenter = yPositions[currentIndex];
		
		return new IntRect(xPosCenter - BOSS_CLOUD_WIDTH/2, yPosCenter - BOSS_CLOUD_HEIGHT/2, BOSS_CLOUD_WIDTH, BOSS_CLOUD_HEIGHT);
		
	}
	
	

	public void drawLightning(int xDraw, int yDraw, int yDrawBase, Graphics g, int beamWidth, Color color) {
		
		ArrayList<IntPoint> pointArray = new ArrayList<RainbowElementalSprite.IntPoint>();

		int xOffSet, yOffSet;
		
		int countOfPoints = (yPos - yPositions[currentIndex]) / PIXELS_BETWEEN_LIGHTNING_POINTS;
		
		for(int i = 0; i < countOfPoints; i++) {
			
			if(i == 0) {
				pointArray.add( new IntPoint(xDraw, yDrawBase));
			} else {
				xOffSet = (int) (Math.random() * beamWidth - beamWidth / 2);
				yOffSet = (int) (Math.random() * beamWidth - beamWidth / 2);
				
				pointArray.add(new IntPoint(xOffSet + xDraw, yOffSet + yDrawBase - i * PIXELS_BETWEEN_LIGHTNING_POINTS));
				
			}
			
		}
		
		pointArray.add(new IntPoint(xDraw, yDraw));
		
		Color origColor = g.getColor();
		g.setColor(color);
		
		for (int i = 0; i < pointArray.size() - 1; i++) {
			g.drawLine(pointArray.get(i).x, pointArray.get(i).y, pointArray.get(i+1).x, pointArray.get(i+1).y); 
		}
		
		g.setColor(origColor);
		
	}
	
	
	public void updateFiring(PonyPanel panel) {
		
		if(lightningTicks <= LIGHTNING_OVERALL_DURATION_TICKS + 1) {
			lightningTicks++;
			return;
		}
		
		int random = (int) (Math.random() * 50);
		
		if(random <= 3) {
//			if(startedLightning + LIGHTNING_OVERALL_DURATION > System.currentTimeMillis())
//				return;
//			
//			startedLightning = System.currentTimeMillis();
			lightningTicks = 0;
		}
	}
	
	public boolean isLightningingForDamage() {
		
//		long currentTime = System.currentTimeMillis();
//		
//		return startedLightning + LIGHTNING_OVERALL_DURATION > currentTime && currentTime > startedLightning + LIGHTNING_CHARGEUP;
		
		return lightningTicks <= LIGHTNING_OVERALL_DURATION_TICKS && lightningTicks >= LIGHTNING_CHARGEUP_TICKS;
	}
	
	public boolean isLightningingForDraw() {
		
//		long currentTime = System.currentTimeMillis();
//		
//		return startedLightning + LIGHTNING_OVERALL_DURATION > currentTime && currentTime > startedLightning + LIGHTNING_DISPLAY_THRESHOLD;
		
		return lightningTicks <= LIGHTNING_OVERALL_DURATION_TICKS && lightningTicks >= LIGHTNING_DISPLAY_THRESHOLD_TICKS;
	}
	
	public void primeImages(Graphics g, int panelWidth, int panelHeight) {
		
//		if(this.cloudDespawnImages != null) {
//			for(CustomImageDataII cid : this.cloudDespawnImages) {
//				cid.primeImage(g, panelWidth, panelHeight);
//			}
//		}
//		
//		if(this.rainbowSpawnImages != null) {
//			for(CustomImageDataII cid : this.rainbowSpawnImages) {
//				cid.primeImage(g, panelWidth, panelHeight);
//			}
//		}
//		
//		if(this.rainbowDespawnImages != null) {
//			for(CustomImageDataII cid : this.rainbowDespawnImages) {
//				cid.primeImage(g, panelWidth, panelHeight);
//			}
//		}
//		
//		if(this.cloudSpawnImages != null) {
//			for(CustomImageDataII cid : this.cloudSpawnImages) {
//				cid.primeImage(g, panelWidth, panelHeight);
//			}
//		}
//		
//		if(rainbowImage != null) {
//			rainbowImage.primeImage(g, panelWidth, panelHeight);
//		}
//
//
//		if(cloudImage != null) {
//			cloudImage.primeImage(g, panelWidth, panelHeight);
//		}
//		
//		if(cloudFlashImage != null) {
//			cloudFlashImage.primeImage(g, panelWidth, panelHeight);
//		}
		
	}




	public int getFlagSpawnX() {
		return flagSpawnX;
	}




	public int getFlagSpawnY() {
		return flagSpawnY;
	}
	
	public IntRect getLightningRect() {
		
		return new IntRect(xPositions[currentIndex] - LIGHTNING_WIDTH / 2, yPositions[currentIndex], LIGHTNING_WIDTH, yPos - yPositions[currentIndex]);
		
	}
	
	
	public boolean isVisible() {
		return isVisible;
	}
}
